//=============================================================================
// Realms BaseMutator.
//=============================================================================

class Realms_Mutator expands Mutator;

var DeathMatchPlus MyGame;

function PostBeginPlay()
{
	MyGame = DeathMatchPlus(Level.Game);
	Super.PostBeginPlay();
}

function bool AlwaysKeep(Actor Other)
{
	local bool bTemp;

	if ( Other.IsA('StationaryPawn') )
		return true;

	if (Other.IsA('TournamentPlayer') || Other.IsA('Bot')) 
        {
		Pawn(Other).PlayerReplicationInfoClass = class'Realms_PRI';
		return true;
	}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}
	
function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{
	Super.ModifyLogin(SpawnClass, Portal, Options);
	SpawnClass = class'Realms_Models_MaleKnight';
}

function ModifyPlayer(Pawn Other)
{
	Other.SetMultiSkin(Other, ""$"Soldier_Armor.armr", ""$"Soldier_Armor.Veteran", 0);
}

defaultproperties
{
}
